#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// perlin-voronoi blob thingsMod01.fsh  by  skarph  
//https://www.shadertoy.com/view/432cRW
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415927

/*

https://gist.github.com/patriciogonzalezvivo/670c22f3966e662d2f83

*/

//	Simplex 3D Noise 
//	by Ian McEwan, Stefan Gustavson (https://github.com/stegu/webgl-noise)
//
vec4 permute(vec4 x){return mod(((x*34.0)+1.0)*x, 289.0);}
vec4 taylorInvSqrt(vec4 r){return 1.79284291400159 - 0.85373472095314 * r;}

float snoise(vec3 v){ 
  const vec2  C = vec2(1.0/6.0, 1.0/3.0) ;
  const vec4  D = vec4(0.0, 0.5, 1.0, 2.0);

// First corner
  vec3 i  = floor(v + dot(v, C.yyy) );
  vec3 x0 =   v - i + dot(i, C.xxx) ;

// Other corners
  vec3 g = step(x0.yzx, x0.xyz);
  vec3 l = 1.0 - g;
  vec3 i1 = min( g.xyz, l.zxy );
  vec3 i2 = max( g.xyz, l.zxy );

  //  x0 = x0 - 0. + 0.0 * C 
  vec3 x1 = x0 - i1 + 1.0 * C.xxx;
  vec3 x2 = x0 - i2 + 2.0 * C.xxx;
  vec3 x3 = x0 - 1. + 3.0 * C.xxx;

// Permutations
  i = mod(i, 289.0 ); 
  vec4 p = permute( permute( permute( 
             i.z + vec4(0.0, i1.z, i2.z, 1.0 ))
           + i.y + vec4(0.0, i1.y, i2.y, 1.0 )) 
           + i.x + vec4(0.0, i1.x, i2.x, 1.0 ));

// Gradients
// ( N*N points uniformly over a square, mapped onto an octahedron.)
  float n_ = 1.0/7.0; // N=7
  vec3  ns = n_ * D.wyz - D.xzx;

  vec4 j = p - 49.0 * floor(p * ns.z *ns.z);  //  mod(p,N*N)

  vec4 x_ = floor(j * ns.z);
  vec4 y_ = floor(j - 7.0 * x_ );    // mod(j,N)

  vec4 x = x_ *ns.x + ns.yyyy;
  vec4 y = y_ *ns.x + ns.yyyy;
  vec4 h = 1.0 - abs(x) - abs(y);

  vec4 b0 = vec4( x.xy, y.xy );
  vec4 b1 = vec4( x.zw, y.zw );

  vec4 s0 = floor(b0)*2.0 + 1.0;
  vec4 s1 = floor(b1)*2.0 + 1.0;
  vec4 sh = -step(h, vec4(0.0));

  vec4 a0 = b0.xzyw + s0.xzyw*sh.xxyy ;
  vec4 a1 = b1.xzyw + s1.xzyw*sh.zzww ;

  vec3 p0 = vec3(a0.xy,h.x);
  vec3 p1 = vec3(a0.zw,h.y);
  vec3 p2 = vec3(a1.xy,h.z);
  vec3 p3 = vec3(a1.zw,h.w);

//Normalise gradients
  vec4 norm = taylorInvSqrt(vec4(dot(p0,p0), dot(p1,p1), dot(p2, p2), dot(p3,p3)));
  p0 *= norm.x;
  p1 *= norm.y;
  p2 *= norm.z;
  p3 *= norm.w;

// Mix final noise value
  vec4 m = max(0.6 - vec4(dot(x0,x0), dot(x1,x1), dot(x2,x2), dot(x3,x3)), 0.0);
  m = m * m;
  // [-1, 1] --> [0, 1]
  return 42.0 * 
         dot( m*m, vec4( dot(p0,x0), dot(p1,x1), 
                         dot(p2,x2), dot(p3,x3) ) );
}
/*

https://github.com/ronja-tutorials/ShaderTutorials/blob/master/Assets/024_White_Noise/WhiteNoise.cginc

*/
float rand3dTo1d(vec3 value, vec3 dotDir) {
    vec3 smallValue = sin(value);
    float random = dot(smallValue, dotDir);
    return fract( sin( random ) * 143758.5453);
}

vec3 rand3dto3d(vec3 value) {
	return vec3(
		rand3dTo1d(value, vec3(12.989, 78.233, 37.719)),
		rand3dTo1d(value, vec3(39.346, 11.135, 83.155)),
		rand3dTo1d(value, vec3(73.156, 52.235, 09.151))
	);
}

/*

https://github.com/ronja-tutorials/ShaderTutorials/blob/master/Assets/028_Voronoi_Noise/voronoi_noise_2d.shader

*/
vec2 voronoiNoise3(vec3 coord) {
    vec3 baseCell = floor(coord);
    float minDistToCell = 100.0;
    vec3 closestCell;
    for ( int x = -1; x <= 1; ++x )
    for ( int y = -1; y <= 1; ++y )
    for ( int z = -1; z <= 1; ++z ) {
        vec3 cell = baseCell + vec3(x,y,z);
        //deterministic
        vec3 cellPosition = cell + rand3dto3d(cell);
        vec3 toCell = cellPosition - coord;
        float distToCell = length(toCell);
        if( distToCell < minDistToCell ) {
            minDistToCell = distToCell;
            closestCell = cell;
        }
    }
    float random = fract( sin( dot( closestCell, vec3(12.989, 78.233, 54.238) ) ) * 143758.5453 );
    return vec2(minDistToCell, random);
}

/*

https://gist.github.com/983/e170a24ae8eba2cd174f

*/
vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    
    vec2 coord = 10.0 * (fragCoord) / iResolution.x;
    
    vec2 vN = voronoiNoise3( vec3(coord, iTime));
    float dist = clamp(vN.x, 0.0, 0.87);
    float value = vN.y;
    
    //these are the fun values
    
    //size of displacemt in direction. may cause artefacting at high values
    float variance_x = 0.5;
    float variance_y = 0.5;
    
    //frequency of waves in coordinate space??
    //diagonal-like matricies make square patterns
    //anti-diagonal like matricies make cross patterns
    //other patterns are more intresting
    //i have no clue whats going on here
    mat2 grain_matrix = mat2(
        5.0, 5.0,
        1.0, 5.0
    );
    //wibble
    float speed_x = 1.0;
    float speed_y = 1.0;
    vec2 noise = vec2(
                  variance_x * snoise( vec3( grain_matrix[0][0] * coord.x, grain_matrix[1][0] * coord.y, speed_x*iTime) ) //x offset
                , variance_y * snoise( vec3( grain_matrix[0][1] * coord.x, grain_matrix[1][1] * coord.y, speed_y*iTime) ) //y offset
    );
    coord = coord + noise;
    vec2 scramble_vN = voronoiNoise3( vec3(coord, iTime));
    float scramble_dist = scramble_vN.x;
    float scramble_value = scramble_vN.y;
    
    vec3 scramble_clr = hsv2rgb( vec3(
            scramble_value,
            clamp(pow(scramble_vN.x, 0.05), 0.0, 1.0),
            pow(1.0 - scramble_dist, 0.5)
    ));
    
    vec3 clr = hsv2rgb( vec3(
            scramble_value,
            clamp(pow(scramble_dist, 0.25), 0.0, 1.0),
            clamp(pow( 1.0 - scramble_dist, 0.75), 0.4, 1.0)
    ));
    //clr = scramble_clr * (1.0 - dist);
    
    //fragColor = vec4(scramble_dist, 0.0, 0.0 ,1.0);
    fragColor = vec4(clr, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

